<?php
header('Content-Type: application/json');

// Capture and decode JSON input
$data = json_decode(file_get_contents('php://input'), true);
$response = array();

// Validate input
$errors = [];

if (empty($data['name'])) {
    $errors[] = 'Name is required.';
}

if (empty($data['email'])) {
    $errors[] = 'Email is required.';
} elseif (!filter_var($data['email'], FILTER_VALIDATE_EMAIL)) {
    $errors[] = 'Invalid email format.';
}

if (empty($data['phone'])) {
    $errors[] = 'Phone is required.';
}

if (empty($data['message'])) {
    $errors[] = 'Message is required.';
}

// If there are errors, return them
if (count($errors) > 0) {
    http_response_code(400);
    echo json_encode(['error' => $errors]);
    exit;
}

// Generate WhatsApp chat link
$whatsappMessage = urlencode("Hello, I am " . $data['name'] . ". My message is: " . $data['message']);
$whatsappNumber = '+916381499815'; // Replace with your WhatsApp number
$whatsappLink = "https://wa.me/{$whatsappNumber}?text={$whatsappMessage}";
$response['whatsapp_link'] = $whatsappLink;

// Path to the CSV file (e.g., /public_html/sheet.csv)
$csvFile = $_SERVER['DOCUMENT_ROOT'] . '/sheet.csv';

// Check if file exists; if not, create it with headers
if (!file_exists($csvFile)) {
    $file = fopen($csvFile, 'w');
    fputcsv($file, ['Name', 'Email', 'Phone', 'Message', 'WhatsApp Link', 'Date']);
    fclose($file);
}

// Append new data to the CSV file
$newRow = [
    $data['name'],
    $data['email'],
    $data['phone'],
    $data['message'],
    $whatsappLink,
    date('Y-m-d H:i:s')
];

$file = fopen($csvFile, 'a');
if ($file) {
    fputcsv($file, $newRow);
    fclose($file);
    $response['csv'] = 'Data added to CSV file successfully.';
} else {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to write data to CSV file.']);
    exit;
}

echo json_encode($response);
