
import { Navbar } from '@/components/Navbar';
import React from 'react';
import Footer from '@/components/Footer';
// require('./page.css');
import Aboutus from '@/components/Aboutus'
import Servicea from '@/components/ServiceBox'

import ContactForm from "@/components/Contact"


export const metadata = {
    title: 'About Us - Toni & Guy',
    description: 'Learn more about Toni & Guy, our values, services, and commitment to providing exceptional hair and beauty experiences.',
    keywords: ['about', 'Toni & Guy', 'hair salon', 'beauty services', 'values', 'team', 'experience'],
    author: 'Toni & Guy',
    openGraph: {
        title: 'About Us - Toni & Guy',
        description: 'Discover Toni & Guy’s dedication to providing top-quality hair and beauty services, our experienced team, and our commitment to excellence.',
        url: 'https://toniandguykolathur.com/about',
        type: 'website',
        images: [
            {
                url: 'https://toniandguykolathur.com/images/TG-White.png',
                alt: 'Toni & Guy About Page Banner',
            }
        ]
    },
    twitter: {
        card: 'summary_large_image',
        title: 'About Us - Toni & Guy',
        description: 'Learn more about Toni & Guy Kolathur and our exceptional approach to hair and beauty services.',
        images: [
            {
                url: 'https://toniandguykolathur.com/images/TG-White.png',
                alt: 'Toni & Guy About Page Banner',
            }
        ]
    },
    canonical: 'https://toniandguykolathur.com/about'
};


const About = () => {
    return (
        <>

            <Navbar />

            <div className="flex flex-col items-center justify-center bg-slate-950 h-80">
                <div className='h-32 w-full'>

                </div>
                <h1 className="lg:text-8xl md:text-5xl text-4xl font-bold text-white " data-aos="fade-up">ABOUT US</h1>

            </div>
            <div className="container mx-auto ">
                <Aboutus />
                <Servicea />
            </div>
            {/* <div className="container-fluid mx-auto contact-page">
                <div className='container contact-page-para grid grid-cols-1 md:grid-cols-2 items-center'>
                    <div className='content-img'>
                        <div className='border'></div>
                        <h2 className="text-2xl mb-4">we did best</h2>
                        <h3 className='text-3xl font-bold mb-4'>Make an Appointment</h3>
                        <p className="text-lg">
                            Pick A Time for Your Cut. After you handpick your barber and service, select a time slot that fits your schedule.
                        </p>

                    </div>
                    <div className='content-text'>
                        <div className='btn1'>
                            <button>Book Now</button>
                        </div>
                    </div>

                </div>
            </div>
 */}
            <ContactForm />


            <Footer />

        </>

    )
}

export default About;
