
import { Navbar } from "@/components/Navbar";
import React from "react";

import ContactForm from "@/components/Contact"
import Footer from '@/components/Footer';


export const metadata = {
    title: 'Contact Us - Toni & Guy',
    description: 'Get in touch with Toni & Guy for any inquiries, bookings, or feedback. We are here to assist you with all your hair and beauty needs.',
    keywords: ['contact', 'Toni & Guy', 'hair salon', 'beauty services', 'inquiries', 'bookings', 'feedback'],
    author: 'Toni & Guy',
    openGraph: {
        title: 'Contact Us - Toni & Guy',
        description: 'Reach out to Toni & Guy Kolathur for assistance with inquiries, bookings, or feedback on our premium hair and beauty services.',
        url: 'https://toniandguykolathur.com/contact',
        type: 'website',
        images: [
            {
                url: 'https://toniandguykolathur.com/images/contact-banner.jpg',
                alt: 'Toni & Guy Contact Page Banner',
            }
        ]
    },
    twitter: {
        card: 'summary_large_image',
        title: 'Contact Us - Toni & Guy',
        description: 'Connect with Toni & Guy Kolathur for inquiries, bookings, and feedback on our services.',
        images: [
            {
                url: 'https://toniandguykolathur.com/images/contact-banner.jpg',
                alt: 'Toni & Guy Contact Page Banner',
            }
        ]
    },
    canonical: 'https://toniandguykolathur.com/contact'
};



const Contact = () => {
    return (
        <>
            <Navbar />

            <div className="flex flex-col items-center justify-center bg-slate-950 h-80">
                <div className='h-32 w-full'>

                </div>
                <h1 data-aos="fade-up" className="lg:text-8xl md:text-5xl text-4xl font-bold text-white " >CONTACT</h1>


            </div>

            <ContactForm />
            <Footer />


        </>

    )
}
export default Contact;