'use client'

import localFont from "next/font/local";
import { FaWhatsapp } from 'react-icons/fa'; // Import social icons
import "./globals.css";
import Aos from "aos";
import "aos/dist/aos.css"; // Import AOS styles
import { useEffect } from "react"; // Import useEffect for AOS initialization

const geistSans = localFont({
  src: "./fonts/GeistVF.woff",
  variable: "--font-geist-sans",
  weight: "100 900",
});
const geistMono = localFont({
  src: "/fonts/GeistMonoVF.woff",
  variable: "--font-geist-mono",
  weight: "100 900",
});
const dashFont = localFont({
  src: "./fonts/dashicons.ttf",
  variable: "--font-toni",
  weight: "100 500 400 900",
});

// export const metadata = {
//   title: "Toni & Guy - Premier Hair and Beauty Salon in Kolathur, Chennai",
//   description: "Discover exceptional hair and beauty services at Toni & Guy Kolathur. We offer a range of unisex services, including haircuts, treatments, bridal styling, and more.",
//   keywords: "Toni & Guy, hair salon, beauty services, Kolathur, Chennai, haircuts, hair treatments, bridal services, unisex beauty",
//   author: "Toni & Guy Kolathur",
//   openGraph: {
//     title: "Toni & Guy - Premier Hair and Beauty Salon in Kolathur, Chennai",
//     description: "Experience top-tier hair and beauty services in a welcoming atmosphere.",
//     url: "https://yourwebsite.com/", // Update this to your actual website
//     siteName: "Toni & Guy Kolathur",
//     images: [
//       {
//         url: "/images/your-image.jpg", // Replace with a relevant image for social sharing
//         width: 800,
//         height: 600,
//         alt: "Toni & Guy Salon in Kolathur"
//       }
//     ],
//     type: "website",
//   },
// };

export default function RootLayout({ children }) {
  useEffect(() => {
    // Initialize AOS
    Aos.init({
      once: true, // Set to true if you want the animations to happen only once
      duration: 600, // Animation duration
      offset: 200,   // Offset to trigger the animation earlier
    });
  }, []);
  return (
    <html lang="en">
      <body
        className={`${geistSans.variable} ${geistMono.variable} antialiased`}
      >
        {children}
        <a
          href="https://wa.me/+919840556263?text=Hello!"
          class="whatsapp-float"
          target="_blank"
        >
          <FaWhatsapp className="text-2xl text-white " />
        </a>

        <script type="module">

        </script>

      </body>
    </html>
  );
}
