
import { Navbar } from '@/components/Navbar';
import React from 'react';
import Footer from '@/components/Footer';
import Service from '@/components/Services';

export const metadata = {
    title: 'Toni & Guy - Our Services',
    description: 'Discover the range of professional hair and beauty services offered at Toni & Guy. From haircuts and treatments to bridal styling and spa services, we cater to all your grooming needs.',
    keywords: ['haircut', 'hair colouring', 'hair treatment', 'bridal', 'spa', 'beauty services', 'Toni & Guy'],
    author: 'Toni & Guy',
    openGraph: {
        title: 'Toni & Guy - Our Services',
        description: 'Explore a wide array of premium hair and beauty services at Toni & Guy Kolathur, from stylish haircuts and expert coloring to luxurious bridal and spa treatments.',
        url: 'https://toniandguykolathur/services',
        type: 'website',
        images: [
            {
                url: 'https://toniandguykolathur/images/1.webp',
                alt: 'Haircut & Hair Colouring Service',
            },
            {
                url: 'https://toniandguykolathur/images/2.jpg',
                alt: 'Hair Treatment Service',
            },
            {
                url: 'https://toniandguykolathur/images/3.jpg',
                alt: 'Bridal Service',
            },
            {
                url: 'https://toniandguykolathur/images/4.jpg',
                alt: 'Spa Service',
            }
        ]
    }
}

const Services = () => {



    return (
        <>
            <Navbar />
            <div className="flex flex-col items-center justify-center bg-slate-950 h-80">
                <div className='h-32 w-full'></div>
                <h1 data-aos="fade-up" className="lg:text-8xl md:text-5xl text-4xl font-bold uppercase text-white">Services</h1>
            </div>

            <Service />


            <Footer />
        </>
    );
}

export default Services;
