// components/Footer.js

import React from 'react';
import Image from 'next/image'; // For optimized image handling
import { FaFacebook, FaTwitter, FaInstagram, FaLinkedin } from 'react-icons/fa'; // Import social icons

export default function Index() {
    return (
        <footer className="bg-[#111] text-white py-20">
            <div className="w-full flex flex-col justify-center items-center">
                {/* Logo */}
                <div className="mb-4">
                    <Image src="/Toni-Guy-LOGO-removebg-preview.png" className='' alt="Logo" width={400} height={150} /> {/* Update the path and dimensions */}
                </div>

                <div className='lg:w-1/3 text-center mb-5 text-gray-400'>Toni & Guy Essensuals has evolved since 1997, expanding globally with a unique “Diffusion line” that combines classic hairdressing with innovative beauty services. Experience why Toni & Guy is trusted worldwide, right here in Chennai</div>

                {/* Contact Details */}
                <div className="text-center mb-4">
                    <p className="text-lg text-gray-400">04448556263 | info@toniguy.com</p>
                    {/* <p className="text-lg"></p> */}
                </div>

                {/* Social Icons */}
                <div className="flex space-x-4 mb-4 text-gray-200">
                    <a href="https://facebook.com" target="_blank" rel="noopener noreferrer">
                        <FaFacebook className="text-2xl text-gray-400 hover:text-blue-600" />
                    </a>
                    <a href="https://twitter.com" target="_blank" rel="noopener noreferrer">
                        <FaTwitter className="text-2xl text-gray-400 hover:text-blue-400" />
                    </a>
                    <a href="https://instagram.com" target="_blank" rel="noopener noreferrer">
                        <FaInstagram className="text-2xl text-gray-400 hover:text-pink-600" />
                    </a>
                    <a href="https://linkedin.com" target="_blank" rel="noopener noreferrer">
                        <FaLinkedin className="text-2xl text-gray-400 hover:text-blue-700" />
                    </a>
                </div>

                {/* Copyright */}
                <div className="text-center text-sm mt-5 text-gray-400">
                    <p>{'&copy;'} {new Date().getFullYear()} TONI&GUY. All rights reserved.</p>
                </div>
            </div>
        </footer>
    );
}
