"use client";

import * as React from "react";
import { motion } from "framer-motion";
import Link from "next/link"; // Import Link
// import style1 from './styles.css';

const variants = {
  open: {
    y: 0,
    opacity: 1,
    transition: {
      y: { stiffness: 1000, velocity: -100 },
    },
  },
  closed: {
    y: 50,
    opacity: 0,
    transition: {
      y: { stiffness: 1000 },
    },
  },
};

const colors = ["#FF008C", "#D309E1", "#9C1AFF", "#7700FF", "#4400FF"];

export const MenuItem = ({ i, title, link }) => {
  const style = { border: `2px solid ${colors[i]}` };
  return (
    <motion.li
      style={{
        listStyle: 'none',
        marginBottom: '20px',
        display: 'flex',
        alignItems: 'center',
        cursor: 'pointer',
      }}
      variants={variants}
      whileHover={{ scale: 1.1 }}
      whileTap={{ scale: 0.95 }}
    >
      <Link href={link}>
        {/* You can wrap the div inside Link for navigation */}
        <div className="text-4xl font-extrabold" style={{

        }}>
          {/* Add any content inside the div */}
          {title}
        </div>
      </Link>
    </motion.li>
  );
};
