import Link from 'next/link'
import React from 'react'

const services = [
    {
        slug: 'haircut-hair-colouring',
        name: 'Haircut & Hair Colouring',
        img: '/images/1.webp',
        description: 'Experience a fresh look with our expert haircut and colouring services. Whether you want a simple trim or a complete style transformation, our professional stylists will tailor the cut and colour to enhance your features and express your personal style. We use high-quality products to ensure your hair remains healthy and vibrant.'
    },
    {
        slug: 'hair-treatment',
        name: 'Hair Treatment',
        img: '/images/2.jpg',
        description: 'Revitalize your hair with our specialized hair treatment services. Our treatments are designed to address various hair concerns, including dryness, damage, and frizz. Using nourishing products, we will restore your hair’s natural shine and softness, leaving you with beautifully healthy locks that are easy to manage.'
    },
    {
        slug: 'bridal',
        name: 'Bridal',
        img: '/images/3.jpg',
        description: 'Make your special day unforgettable with our comprehensive bridal services. From elegant hairstyles to stunning makeup, our experienced team will work closely with you to create the perfect look that complements your wedding theme. We offer trial sessions to ensure you are completely satisfied and confident on your big day.'
    },
    {
        slug: 'spa',
        name: 'Spa',
        img: '/images/4.jpg',
        description: 'Indulge in our relaxing spa treatments designed to rejuvenate your mind and body. Our spa services include soothing massages, refreshing facials, and revitalizing body scrubs. Each treatment is customized to meet your individual needs, helping you to unwind and escape from the stresses of daily life in a tranquil environment.'
    }
];


export default function Index() {
    return (
        <>
            <div className="flex flex-col my-10 container mx-auto">
                {services.map((ser, index) => (
                    <div data-aos="fade-up" key={index} className={`flex gap-10 h-full ${index % 2 == 0 ? 'lg:flex-row' : 'lg:flex-row-reverse'} flex-col justify-center items-center p-4`}>
                        <div className='bg-cover bg-center md:h-[45rem] h-96 md:w-1/2 w-full' style={{
                            backgroundImage: `url(${ser.img})`,
                        }}></div>
                        <div className="ml-4 text-left md:w-1/2 space-y-10">
                            <h2 className="lg:text-5xl uppercase md:text-3xl text-3xl font-extrabold">{ser.name}</h2>
                            <p className="text-gray-700">{ser.description}</p>
                            <br />
                            <Link style={{ border: '5px black solid', padding: '7px 25px' }} className='font-semibold hover:text-white hover:bg-black' href={'/services/' + ser.slug}>
                                Read More
                            </Link>
                        </div>
                    </div>
                ))}
            </div>
        </>
    )
}
